using System;
using System.Data;
using System.Collections;
using System.Reflection;
using System.Drawing;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections.Specialized;
using System.Windows.Forms;
using Borland.Eco.Persistence.ORMapping;
using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.Handles;
using Borland.Eco.Handles.Design;
using Borland.Eco.Persistence;
using Borland.Eco.Globalization;
using Borland.Eco.ModelLayer;
using Borland.Eco.ModelLayer.Bds;
using Borland.Studio.ToolsAPI;

namespace ModelAuditor
{
	[ToolboxBitmap(typeof(ModelAuditorTool), "ModelAuditorTool.bmp")]
	public class ModelAuditorTool: EcoToolButtonBase
	{
		public static void IDERegister()
		{
			EcoSpaceDesignerToolbox.AddTool(new ModelAuditorTool());
		}
		public override string GetCaption()
		{
			return "OCL audit";
		}
		public override void Execute(ExecuteArgs executeArgs)
		{
			IOTAProject proj = BorlandIDE.ModuleServices.ActiveProject;
			IModelService ms = BorlandIDE.GetService(typeof(IModelService)) as IModelService;

			MainForm form = new MainForm(ms, proj);
			form.ShowDialog();
		}
		public override bool RequireRecompile()
		{
			return false;
		}
	}
}
